/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import com.github.L_Ender.cataclysm.init.ModSounds;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DurabilityDisplayModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class OverDriveModifier
extends Modifier
implements BlockBreakModifierHook,
MeleeHitModifierHook,
ProjectileLaunchModifierHook,
DurabilityDisplayModifierHook,
InventoryTickModifierHook,
MeleeDamageModifierHook,
BreakSpeedModifierHook,
ConditionalStatModifierHook {
    private final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "overdrive");
    private final ResourceLocation OVER = new ResourceLocation("tinkerscalibration", "overdrive_time");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.BLOCK_BREAK, ModifierHooks.MELEE_HIT, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.DURABILITY_DISPLAY});
    }

    public void afterBlockBreak(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (context.isEffective() && RANDOM.nextFloat() <= 0.3f * (float)modifier.getLevel()) {
            persistentData.putInt(this.KEY, persistentData.getInt(this.KEY) + 1);
            LivingEntity holder = context.getLiving();
            Level world = holder.f_19853_;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, holder.m_20185_(), holder.m_20186_(), holder.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, NamespacedNBT persistentData, boolean primary) {
        ModDataNBT tp = tool.getPersistentData();
        if (primary && arrow != null && arrow.m_36792_() && RANDOM.nextFloat() <= 0.3f * (float)modifier.getLevel()) {
            tp.putInt(this.KEY, tp.getInt(this.KEY) + 1);
            Level world = shooter.f_19853_;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (context.isFullyCharged() && RANDOM.nextFloat() <= 0.3f * (float)modifier.getLevel()) {
            persistentData.putInt(this.KEY, persistentData.getInt(this.KEY) + 1);
            LivingEntity holder = context.getAttacker();
            Level world = holder.f_19853_;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, holder.m_20185_(), holder.m_20186_(), holder.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public Boolean showDurabilityBar(IToolStackView tool, ModifierEntry modifier) {
        return null;
    }

    public int getDurabilityWidth(IToolStackView tool, ModifierEntry modifier) {
        return 0;
    }

    public int getDurabilityRGB(IToolStackView tool, ModifierEntry modifier) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(this.KEY, 3)) {
            if (persistentData.getInt(this.KEY) == 1) {
                return 16775479;
            }
            if (persistentData.getInt(this.KEY) == 2) {
                return 16762933;
            }
            if (persistentData.getInt(this.KEY) == 3) {
                return 16751926;
            }
            if (persistentData.getInt(this.KEY) == 4) {
                return 16742975;
            }
            return 0xFF4443;
        }
        return 0;
    }

    public void onInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(this.OVER, 3) && holder.f_19797_ % 20 == 0) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, holder.m_20185_(), holder.m_20186_(), holder.m_20189_(), 0.0, 0.0, 0.0);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, holder.m_20185_(), holder.m_20186_(), holder.m_20189_(), 0.0, 0.0, 0.0);
            persistentData.putInt(this.OVER, persistentData.getInt(this.OVER) - 1);
            if (persistentData.getInt(this.OVER) == 0) {
                persistentData.remove(this.KEY);
            }
        }
        if (persistentData.getInt(this.KEY) == 6) {
            persistentData.remove(this.KEY);
            persistentData.putInt(this.OVER, 5);
            holder.m_5496_((SoundEvent)ModSounds.HARBINGER_CHARGE.get(), 1.0f, 0.5f);
        }
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(this.OVER, 3)) {
            if (stat == ToolStats.DRAW_SPEED) {
                return baseValue * (1.0f + RANDOM.nextFloat(0.3f, 0.8f) * (float)modifier.getLevel());
            }
            if (stat == ToolStats.VELOCITY) {
                return baseValue * (1.0f + RANDOM.nextFloat(0.3f, 0.8f) * (float)modifier.getLevel());
            }
        }
        return baseValue;
    }

    public float getMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(this.OVER, 3)) {
            return damage * (1.0f + RANDOM.nextFloat(0.3f, 0.8f) * (float)modifier.getLevel());
        }
        return damage;
    }

    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifier, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(this.OVER, 3)) {
            event.setNewSpeed(event.getNewSpeed() * (1.0f + RANDOM.nextFloat(0.3f, 0.8f) * (float)modifier.getLevel()));
        }
    }
}

